####################################################
### code chunk number : Simulations: Consistency
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
ptm = proc.time()

## initialization
alpha = 2            ## hyperparameter
beta = 1             ## hyperparameter
# N = 10^(1:3); N      ## sample size
N = 1e3 * 2^c(0, 1, 2, 3); N      ## sample size
L_N = length(N); L_N ## the length of N
M = 100              ## number of simulations, to calculate the probability

set.seed(1) 
n = N[L_N]
X = matrix(0, nrow = M, ncol = n)
for (m in 1:M){
	theta_m = rgamma(n = n, shape = alpha, rate = beta)
	X[m, ] = rpois(n = n, lambda = theta_m)
}

## Histogram,
hist(X[1, ], probability = FALSE,
    main = paste("Histogram of" , "X[1, ]"), 
    xlab = "x")

F1 = F2 = matrix(0, nrow = L_N, ncol = 2)
colnames(F1) = c("alpha_1", "beta_1")
colnames(F2) = c("alpha_2", "beta_2")
alpha_1 = beta_1 = matrix(0, nrow = L_N, ncol = M)
alpha_2 = beta_2 = matrix(0, nrow = L_N, ncol = M)
for (j in 1:L_N){
	cat("\n"); print(paste("In this cycle, j = ", j, sep = "")); cat("\n")
	n = N[j]; n
	alpha_1_beta_1 = alpha_2_beta_2 = matrix(0, nrow = M, ncol = 2)
	for (m in 1:M){
		cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
		
		## Note that x is the sample, it is used in the calculation of the MLEs. 
		## See moment_fun().
		x = X[m, 1:n]
		alpha_1_beta_1[m, ] = Moment_estimators(x)
		cat("alpha_1_beta_1[m, ] \n"); print(alpha_1_beta_1[m, ]); cat("\n")
		
		## The MLE is very sensitive to the initial guess. 
		## The moment estimator is usually a good initial guess.
		res_Newtons_m = Newtons(fun = moment_fun, p = alpha_1_beta_1[m, ], x = x)
		alpha_2_beta_2[m, ] = res_Newtons_m$root
		cat("alpha_2_beta_2[m, ] \n"); print(alpha_2_beta_2[m, ]); cat("\n")
	}
	alpha_1[j, ] = alpha_1_beta_1[, 1]
	beta_1[j, ]  = alpha_1_beta_1[, 2]
	
	alpha_2[j, ] = alpha_2_beta_2[, 1]
	beta_2[j, ]  = alpha_2_beta_2[, 2]
}
Abs_alpha_1 = abs(alpha_1 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_1, 3)
Abs_beta_1  = abs(beta_1 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_1, 3)

Abs_alpha_2 = abs(alpha_2 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_2, 3)
Abs_beta_2  = abs(beta_2 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_2, 3)

## epsilon = 1, 0.5, 0.1
## moment estimator
epsilon = 1
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)

epsilon = 0.5
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)

epsilon = 0.1
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)

## MLE
epsilon = 1
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)

epsilon = 0.5
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)

epsilon = 0.1
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)

time_new = proc.time() - ptm; time_new

